
require("mysqloo")
SFP.DB = {}

SFP.DB.STATUS = SFP.DBSTATUS.INITIALIZING
SFP.DB.READY = false

SFP.DB.CONN = mysqloo.connect(
  SFP.CONFIG("Database"):Get("Host"),
  SFP.CONFIG("Database"):Get("User"),
  SFP.CONFIG("Database"):Get("Password"),
  SFP.CONFIG("Database"):Get("Database"),
  SFP.CONFIG("Database"):Get("Port")
)

function SFP.DB.CONN:onConnected()
  Aw:LogTrace("MySQL connection established:\n  - version: %s\n  - host: %s",
  SFP.DB.CONN:serverInfo(), SFP.DB.CONN:hostInfo())
  SFP.DB.READY = true
  SFP.DB.STATUS = SFP.DBSTATUS.MIGRATING
  SFP.DB:Migrate(function() SFP.FireDB() end)
  SFP.DB.STATUS = SFP.DBSTATUS.SUCCESS
end

function SFP.DB.CONN:onConnectionFailed( err )
  Aw:LogTrace("MySQL database connection failed : %s", err)
  SFP.DB.STATUS = SFP.DBSTATUS.FAILED
end

function SFP.DB:Get()
    return SFP.DB.CONN
end


function SFP.DB:Migrate(fCallback)
  Aw:LogTrace("Running migration procedure.")

  local migration = [[
    CREATE TABLE IF NOT EXISTS `:servertbl:` (
      SDataID int(255) PRIMARY KEY NOT NULL AUTO_INCREMENT,
      SteamID varchar(255) UNIQUE NOT NULL,
      server_model varchar(255) DEFAULT NULL,
      server_rank varchar(255) DEFAULT NULL,
      server_playtime int(255) NOT NULL DEFAULT 0
    );
  ]]
  migration = migration:Replace(
    ":servertbl:",
    SFP.CONFIG("General"):Get("serverTable")
  )

  local migrationQuery = self.CONN:query(migration)

  function migrationQuery:onSuccess()
    Aw:LogTrace("Server included on panel database : All good\n")
    if fCallback then fCallback() end
  end

  function migrationQuery:onError(err)
    Aw:LogTrace("Failed to start server -> Panel integration : err \n%s\nQuery: %s", err, migration)
  end

  migrationQuery:start()

end

function SFP.DB:Query(query, onSuccess, onFail)
  local query = self.CONN:query(query)

  function query:onSuccess(data)
    if onSuccess then onSuccess(data) end
  end

  function query:onFail(err)
    if onFail then onFail(err) end
  end

  query:start()
end

hook.Add("SFP:ModulesLoaded", "StartSFPDatabase", function()
  Aw:LogTrace("All found modules where loaded : Initializing Database.")
  if not SFP.DB.READY then
    SFP.DB.CONN:connect()
  else
    Aw:LogTrace("MySQL Connection was previously created, keeping that one.")
  end
end)