local MODULE = {}
MODULE.Name = "Auto claim"
MODULE.Version = "1.0"
MODULE.Enabled = true
MODULE._ServerID = -1

function MODULE:CanLoad()
    return true
end

function MODULE:OnLoad()
    self._tPendingPlayers = {}

    local STATUS = {
        NOTREADY = '',
        PENDING = 'pending',
        DELIVERED = 'completed'
    }

    local serverConn = string.Explode( ":", SFP.CONFIG("General"):Get("ServerIP") )
    local ip = serverConn[1]
    local port = serverConn[2]
    
    local query = [[
        SELECT id
        FROM `sfp_servers`
        WHERE ip = ':ip:'
        AND port = ':port:'
        AND game = 'garrysmod'
    ]]

    query = query:Replace(":ip:", ip)
    query = query:Replace(":port:", port)

    local queryServer = SFP.DB:Get():query(query)

    function queryServer:onSuccess(row)
        if #row == 0 then
        Aw:LogTrace("THIS SERVER IS NOT REGISTERED ON PANEL - PLEASE ADD THE SERVER.\n: query %s", query)
        Aw:LogTrace("Server package claim is now disabled because we couldn't find the ServerID on panel database!")
        return
        else
        Aw:LogTrace("Server -> Panel ID identified : %s : All good", row[1].id)
        end

        MODULE._ServerID = row[1].id
    end

    queryServer:start()

    hook.Add("PlayerInitialSpawn", "SFP:AutoClaimOnSpawn", function(pPlayer)
        pPlayer:ChatPrint("SFPortal | Packages are auto claimed in 30 seconds.")
        MODULE._tPendingPlayers[pPlayer:SteamID64()] = pPlayer
        timer.Create("SFP:AutoClaim:" .. pPlayer:SteamID64() .. "", 10, 1, function()
            hook.Run("SFP:DependPlayerPackage", pPlayer) -- Calling a hook, so we don't break the whole server XD
        end)
    end)

    hook.Add("SFP:DependPlayerPackage", "SFP:DependPackageHook", function(pPlayer)
        if (MODULE._ServerID == -1) then
            Aw:LogError("Failed server id identification : Stopping package delivery")
            return
        end

        if not pPlayer or not IsValid(pPlayer) then
            Aw:LogTrace("Tried recovering purchased packages for invalid player, skipping")
        end

        local query = [[
            SELECT *
            FROM `sfp_order_commands`
            WHERE server = ':servertable:' AND (steamid = ':steamid:' or steamid = ':steamid32:') AND status = ':pendingenum:';
        ]];

        query = query:Replace(":servertable:", MODULE._ServerID)
        query = query:Replace(":steamid:", pPlayer:SteamID64())
        query = query:Replace(":steamid32:", pPlayer:SteamID())
        query = query:Replace(":pendingenum:", STATUS.PENDING)

        local queryDelivered = SFP.DB:Get():query(query)
        Aw:LogTrace("Package searching query:\n%s", query)
        function queryDelivered:onSuccess(rows)
            Aw:LogTrace("Found %s unclaimed packages for player %s", #rows, pPlayer)
            for _, data in pairs(rows) do
                if data.status == STATUS.NOTREADY or data.status == STATUS.DELIVERED then
                    Aw:LogTrace("Found inactive/alredy claimed package with id: %s : Skipping", id)
                    continue
                end

                local query = [[
                    SELECT command
                    FROM `sfp_commands`
                    WHERE id = :commandid:
                ]]

                query = query:Replace(":commandid:", data.commandid)
                
                queryCommand = SFP.DB:Get():query(query)

                function queryCommand:onSuccess(commandRows)
                    Aw:LogTrace("Microsoft certified indian scammer is checking your google card of id: %s", data.id)
                    local query = [[
                        UPDATE `sfp_order_commands`
                        SET status = ':newstatus:', reason = 'Claimed by in-game addon'
                        WHERE server = ':servertable:' AND (steamid = ':steamid:' or steamid = ':steamid32:') AND id = ':packageid:';
                    ]]
                    
                    query = query:Replace(":servertable:", MODULE._ServerID)
                    query = query:Replace(":steamid:", pPlayer:SteamID64())
                    query = query:Replace(":steamid32:", pPlayer:SteamID())
                    query = query:Replace(":packageid:", data.id)
                    query = query:Replace(":newstatus:", STATUS.DELIVERED)

                    queryUpdatePackage = SFP.DB:Get():query(query)
                    function queryUpdatePackage:onSuccess()

                        local command = commandRows[1].command
                        command = command:Replace( '$steamid', pPlayer:SteamID64() )
                        command = command:Replace( '$steam32', pPlayer:SteamID() )
                        command = command:Replace( '$steam64', pPlayer:SteamID64() )
                        command = command:Replace( '$name', pPlayer:Nick() )
                        command = command:Replace( '$nickname', pPlayer:Nick() )
                        command = command:Replace( '$uid', pPlayer:UniqueID() )
                        command = command:Replace( '$message', data.message)
                        command = string.Trim(command)
                        
                        local commandTable = string.Explode(' ', command)
                        


                        local sCommand = commandTable[1]
                        local varCommand = unpack( commandTable, 2, table.Count(commandTable) )


                        game.ConsoleCommand( command .. '\n' )

                        Aw:LogTrace("Claimed package %s for player %s with Command %s : All good", pPlayer, data.id, command)
                    end
                    function queryUpdatePackage:onError(err)
                        Aw:LogTrace("Failed updating status of package for player %s package id: %s\n: Err %s", pPlayer, data.id, err)
                    end

                    Aw:LogTrace("Indian scammer trying to run query: \n%s", query)
                    queryUpdatePackage:start()
                end

                function queryCommand:onError(err)
                    Aw:LogTrace("Failed fetching package command for player %s package id: %s\n : Err %s", pPlayer, data.id, err)
                end

                queryCommand:start()
            end
        end

        function queryDelivered:onError(err)
        end

        queryDelivered:start()

    end)

end


SFP:RegisterModule(MODULE)
