local MODULE = {}
MODULE.Name = "Player sync"
MODULE.Version = "1.0"
MODULE.Enabled = true

function MODULE:CanLoad()
    return SFP.CONFIG("General"):Get("enablePlayerSync")
end

function MODULE:OnLoad()
    hook.Add("PlayerInitialSpawn", "sfportal:pdata:pconnect", function(pPlayer)
        local query = [[
            SELECT steamid
            FROM sfp_users
            WHERE steamid = ':sid64:'
        ]]

        query = query:Replace( ":sid64:", pPlayer:SteamID64() )

        local queryPlayer = SFP.DB:Get():query(query)

        function queryPlayer:onSuccess(row)
            if #row <= 0 then
                Aw:LogTrace("Player %s is not in the database : Adding it", pPlayer:Nick())
                local query = [[
                    INSERT INTO sfp_users (steamid, name, auth, status, avatar, fullname, activated, email_confirmed, last_activity, created_at, last_login_at)
                    VALUES (':sid64:', ':name:', 1, 'active', ':avatar:', ':name:', 1, 0, ':time:', ':date:', ':date:')
                ]]

                query = query:Replace( ":sid64:", pPlayer:SteamID64() )
                query = query:Replace( ":name:", pPlayer:Nick() )
                query = query:Replace( ":avatar:", "https://steamcdn-a.akamaihd.net/steamcommunity/public/images/avatars/fe/fef49e7fa7e1997310d705b2a6158ff8dc1cdfeb_full.jpg" )
                query = query:Replace( ":time:", os.time() )
                query = query:Replace( ":date:", os.date("%Y-%m-%d %H:%M:%S") )

                local queryInsert = SFP.DB:Get():query(query)

                function queryInsert:onSuccess(row)
                    Aw:LogTrace("Player %s added to the database", pPlayer:Nick())
                end

                function queryInsert:onError(err)
                    Aw:LogTrace("Failed to add player %s to the database : err\n%s\n: query %s", pPlayer:Nick() or "<Invalid player>", err, query)
                end

                queryInsert:start()
            end
        end

        function queryPlayer:onError(err)
        end

        queryPlayer:start()

    end)
end


SFP:RegisterModule(MODULE)
