local MODULE = {}

MODULE.Name = "DataSync"
MODULE.Enabled = true
MODULE.Version = 2.1

function MODULE:CanLoad(DBStatus)
  return true -- Yeah, you can't (or shouldn't) disable that.
end

function MODULE:Migrate()
  print("SERVEUR", SFP.CONFIG("General"):Get("serverTable"))
end

function MODULE:OnLoad()
  self.Players = self.Players or {}

  hook.Add("PlayerInitialSpawn", "sfportal:pdata:pconnect:adddb", function(pPlayer)
    MODULE.Players[pPlayer:SteamID64()] = {}
    Aw:LogTrace("Player %s Joined : Added to list of synced players", pPlayer:Nick())
    local query = [[
     SELECT server_playtime
     FROM `:servertable:`
     WHERE SteamID = ':sid64:'
    ]]

    query = query:Replace(':servertable:', SFP.CONFIG("General"):Get("serverTable") )
    query = query:Replace( ":sid64:", pPlayer:SteamID64() )

    local queryTime = SFP.DB:Get():query(query)

    function queryTime:onSuccess(row)
      pPlayer.playtimeCalc = row.server_playtime or 0
    end

    function queryTime:onError(err)
      Aw:LogTrace("Failed to fetch playtime for player %s : err\n%s\n: query %s", pPlayer:Nick() or "<Invalid player>", err, query)
    end

    queryTime:start()

  end)

  hook.Add("PlayerDisconnected", "sfportal:pdata:pdisconnect", function(ply)
      MODULE:SavePlayer(ply)
  end)

  hook.Add("ShutDown", "sfportal::module_gather::shutdown", function()
      MODULE:Fetch()
  end)

end


function MODULE:SavePlayer(pPlayer)
  if !self.Players[pPlayer:SteamID64()] then return end
  local updatePair = ""

  if !pPlayer:Nick() then
    return
  end
  
  if !pPlayer or !IsValid(pPlayer) then
    Aw:LogTrace("Tried to sync data for invalid player, skipping this player for now : Start good")
    return
  end

  for key, content in pairs(self.Players[pPlayer:SteamID64()]) do
      if (!content.value) then continue end
      if (content.value == "") then continue end
      if (content.value == 0) then continue end

      if (type(content.value) == "string") then
          content.value = content.value
      end

      if (content.isSum) then
          updatePair = updatePair .. key .. " = " .. key .. " + " .. content.value .. ","
      else
          updatePair = updatePair .. key .. " = '" .. content.value .. "',"
      end
  end

  local query = [[
      INSERT INTO `:servertable:` (SteamID)
      VALUES(:sid64:)
      ON DUPLICATE KEY
      UPDATE :tuple:]]

  query = query:Replace(":servertable:", SFP.CONFIG("General"):Get("serverTable"))
  query = query:Replace(":sid64:", pPlayer:SteamID64())
  query = query:Replace(":tuple:", updatePair)

  if string.EndsWith( query, ',' ) then
      query = string.sub( query, 1, -2 ) .. ";"
  end

  querySave = SFP.DB:Get():query(query)

  if query == '' or query == ' ' then 
    return 
  end

  function querySave:onSuccess(row)
    Aw:LogTrace("Synced player data for %s : All good", pPlayer)
  end

  function querySave:onError(err)
    Aw:LogTrace("Sync data failed for player %s : err %s\n: query %s", pPlayer or "<Invalid Player>", err, query)
  end

  querySave:start()
end


function MODULE:SaveAll()
  Aw:LogTrace("Working on data sync for all players : Start good")
  for _, pPlayer in pairs(player.GetAll()) do
    Aw:LogTrace("Currently checking data for player %s : memory reference : %s", pPlayer, self.Players[pPlayer:SteamID64()])
    if not (self.Players[pPlayer:SteamID64()]) then
      Aw:LogTrace("SFP | PlayerData: Trying to get data from %s but playerdata is now empty : err\nHere's a couple reasons of why that may happen\n- You're editting files with lua refresh enabled : just ignore\n- The player data is not being stored : contact us on support discord\n- There's no data to be saved : just ignore", pPlayer:SteamID64())
      return
    end
    self.Players[pPlayer:SteamID64()]["server_model"] = { value = pPlayer:GetModel() }
    self.Players[pPlayer:SteamID64()]["server_rank"] = { value = pPlayer:GetUserGroup() }

    if (!pPlayer.playtimeCalc) then
      pPlayer.playtimeCalc = CurTime()
      Aw:LogTrace("ServerPlaytimeSync - SAVEALL : %s has no playtime - Setting up.", pPlayer:Nick())
    end

    self.Players[pPlayer:SteamID64()]["server_playtime"] = { value = CurTime() - pPlayer.playtimeCalc, isSum = true }
    Aw:LogTrace("ServerPlaytimeSync - SAVEALL : %s : %s", pPlayer:Nick(), pPlayer.playtimeCalc)

    self:SavePlayer(pPlayer)
    pPlayer.playtimeCalc = CurTime()
  end
end

function MODULE:Fetch()
  Aw:LogTrace("Starting data sync procedure")
  self:SaveAll()
end


SFP:RegisterModule(MODULE)