local MODULE = {}
MODULE.Name = "TTT Integration"
MODULE.Version = "1.0"
MODULE.Enabled = true

function MODULE:CanLoad()
    return engine.ActiveGamemode() == "terrortown"
end

-- Called on all modules right after SFPortal Database is ready
-- There is no delay needed because the database module will do everything in a queue * pool
-- This also allows modules to have more control over the database, instead of relying on obscure functions inside the addon.
function MODULE:Migrations()

    Aw:LogTrace("Running TTT Migrations")

    local check = [[
    SELECT * FROM information_schema.COLUMNS
      WHERE TABLE_SCHEMA = ':database:'
      AND TABLE_NAME = ':servertbl:'
      AND COLUMN_NAME = 'karma_stored '
      LIMIT 1;
    ]]

    check = check:Replace(":database:", SFP.CONFIG("MySQL"):Get("Database") )
    check = check:Replace(":servertbl:", SFP.CONFIG("General"):Get("serverTable"))

    local seed = [[
      ALTER TABLE :serverTable:
        ADD karma_stored bigint (255) DEFAULT 10000;
      ALTER TABLE :serverTable:
        ADD TTT_kills int(255) DEFAULT 0;
      ALTER TABLE :serverTable:
        ADD TTT_times_traitor int(255) DEFAULT 0;
      ALTER TABLE :serverTable:
        ADD TTT_deaths int(255) DEFAULT 0;
      ALTER TABLE :serverTable:
      ADD TTT_times_detective int(255) DEFAULT 0;
    ]]

    seed = seed:Replace(":serverTable:", SFP.CONFIG("General"):Get("serverTable"))

    local checkQuery = SFP.DB:Get():query(check)

    function checkQuery:onSuccess(data)
      if #data == 0 then
        Aw:LogTrace("TTT Integration columns not found, migrating data")

        local seedQuery = SFP.DB:Get():query(seed)

        function seedQuery:onSuccess(data)
          Aw:LogTrace("Migrated TTT Data to panel database : All good")
        end

        function seedQuery:onError(err)
          Aw:LogError("Seeding failed for TTT Module : err\n%s\n : query %s", err, seed)
          return
        end

        seedQuery:start()
      else
        Aw:LogTrace("TTT Integration detected : All good")
      end
    end

    function checkQuery:onError(err)
      Aw:LogError("Migration failed for TTT module : err\n%s\n : query %s", err, check)
    end

    checkQuery:start()
end

function MODULE:OnLoad()
    self.DeathData = self.DeathData or {}
    self.KillData = self.KillData or {}
    self.Traitor = self.Traitor or {}
    self.Detective = self.Detective or {}

    hook.Add ("PlayerDeath", "SFPortal:TTT:PlayerDeathData", function (victim, inflictor, attacker)
      if (attacker:IsPlayer ()) then
        MODULE.KillData[attacker] = (MODULE.KillData[attacker] or 0) + 1
      end
      if (victim:IsPlayer ()) then
        MODULE.DeathData[victim] = (MODULE.DeathData[victim] or 0) + 1
      end
      print("Killed people on this shit, here's table of result")
      print("Kill:")
      PrintTable(MODULE.KillData)
      print("Death:")
      PrintTable(MODULE.DeathData)
    end)
  
    hook.Add("TTTBeginRound", "SFPortal:TTT:Roles", function()
      for k, v in pairs(player.GetAll()) do
        if v:GetRole() == ROLE_DETECTIVE then
          MODULE.Detective[v] = (MODULE.Detective[v] or 0) + 1
        elseif v:GetRole() == ROLE_TRAITOR then
          MODULE.Traitor[v] = (MODULE.Traitor[v] or 0) + 1
        end	
      end
    end)
end

function MODULE:getTTTKarma(ply)
    if KARMA.cv.persist:GetBool() then return ply:GetLiveKarma() end

    return KARMA.cv.starting:GetInt()
end

function MODULE:Fetch()
  Aw:LogTrace("Inserting TTT Data to sync module : All good")
    for _, pPlayer in pairs(player.GetAll()) do
        SFP._tModules["DataSync"].Players[pPlayer:SteamID64()]["TTT_deaths"] = {
            value = self.DeathData[pPlayer],
            isSum = true
        }

        SFP._tModules["DataSync"].Players[pPlayer:SteamID64()]["TTT_kills"] = {
            value = self.KillData[pPlayer],
            isSum = true
        }

        SFP._tModules["DataSync"].Players[pPlayer:SteamID64()]["TTT_times_traitor"] = {
            value = self.Traitor[pPlayer],
            isSum = true
        }

        SFP._tModules["DataSync"].Players[pPlayer:SteamID64()]["TTT_times_detective"] = {
            value = self.Detective[pPlayer],
            isSum = true
        }

        SFP._tModules["DataSync"].Players[pPlayer:SteamID64()]["karma_stored"] = {
            value = self:getTTTKarma(pPlayer)
        }

        self.DeathData[pPlayer] = 0
        self.KillData[pPlayer] = 0
        self.Traitor[pPlayer] = 0
        self.Detective[pPlayer] = 0
    end
end

SFP:RegisterModule(MODULE)
