SFP.NET = SFP.NET or {}

util.AddNetworkString("SFP_RequestAppealsList")
util.AddNetworkString("SFP_RequestServerInfo")
util.AddNetworkString("SFP_RequestChatLog")
util.AddNetworkString("SFP_RequestInfo")
util.AddNetworkString("SFP_UI_MESSAGE")
util.AddNetworkString("SFP_UI_ERROR")
util.AddNetworkString("SFP_OpenMenu")
util.AddNetworkString("SFP_DenyAppeal")
util.AddNetworkString("SFP_AcceptAppeal")
util.AddNetworkString("SFP_SendMessage")
util.AddNetworkString("SFP_SendAppealMessage")

local function cockBlock(pPlayer)
  if !pPlayer then return true end
  if !IsValid(pPlayer) then return true end
  if !pPlayer:IsAdmin() then return true end
  
  return false
end

function SFP.NET:SendUIError( pPlayer, sChannel, err)
  net.Start("SFP_UI_ERROR")
    net.WriteString(sChannel)
    net.WriteString(err)
  net.Send(pPlayer)
end

net.Receive("SFP_RequestAppealsList", function(xLen, pcaller)
  SFP.NET:SendAppealsList(pcaller)
end)

function SFP.NET:SendAppealsList(pCaller)
  if (cockBlock(pCaller)) then 
    return 
  end
  local tAppeals = {}

  local serverConn = string.Explode(  ":", SFP.CONFIG("General"):Get("ServerIP") )
  local ip = serverConn[1]
  local port = serverConn[2]

  local query = [[
    SELECT id
    FROM `sfp_servers`
    WHERE ip = ':ip:'
    AND port = ':port:'
    AND game = 'garrysmod';
  ]]

  query = query:Replace(":ip:", ip)
  query = query:Replace(":port:", port)


  local queryServer = SFP.DB:Get():query(query)
  function queryServer:onSuccess(data)
    local serverID = data[1].id
    -- Querying Appeals
    
    local query = [[
      SELECT a.id, a.banid, a.status, b.PSteamID, b.ASteamID, b.Reason, b.Time
      FROM sfp_appeals a
      INNER JOIN sfp_bans b on a.banid = b.BanID
      WHERE b.banid = a.banid
      AND (a.status = 'active' OR a.status = 'in_progress')
      LIMIT 50;
    ]]

    query = query:Replace(":serverid:", serverID)
    local appealsQuery = SFP.DB:Get():query(query)

    function appealsQuery:onSuccess(appealsData)
      local appealsCollection = {}
      if (#appealsData == 0) then
        local jsonDATA = util.TableToJSON(appealsCollection)
        local compressedDATA = util.Compress(jsonDATA)
        net.Start("SFP_RequestAppealsList")
          net.WriteUInt(#compressedDATA, 32)
          net.WriteData(compressedDATA, #compressedDATA)
        net.Send(pCaller)
      end

      for _ = 1, #appealsData do
      
        appealsCollection[_] = {
          ID = appealsData[_].id,
          BanID = appealsData[_].banid,
          Status = appealsData[_].status,
          PSteamID = appealsData[_].PSteamID,
          ASteamID = appealsData[_].ASteamID,
          Reason = appealsData[_].Reason,
          Time = appealsData[_].Time,
          Comments = {}
        }

        local query = [[
          SELECT replyid, reply, replydate FROM sfp_appealreplies
          WHERE appealid = ':appealid:'
          ORDER BY replydate ASC;
          ]];
          
          query = query:Replace(':appealid:', appealsData[_].id)
          local appealRepliesQuery = SFP.DB:Get():query(query)
          function appealRepliesQuery:onSuccess(repliesData)

            for i = 1, #repliesData do
              appealsCollection[_].Comments[i] = {
                ID = repliesData[i].replyid,
                Name = repliesData[i].replyname,
                Reply = repliesData[i].reply,
                Date = repliesData[i].replydate
              }
              if (i == #repliesData) then
                if ( _ == #appealsData) then
                  local jsonDATA = util.TableToJSON(appealsCollection)
                  local compressedDATA = util.Compress(jsonDATA)
                  net.Start("SFP_RequestAppealsList")
                    net.WriteUInt(#compressedDATA, 32)
                    net.WriteData(compressedDATA, #compressedDATA)
                  net.Send(pCaller)
                end
              end
            end
            
            
          end

          function appealRepliesQuery:onError(err)
            Aw:LogError("Error on the query :), %s", err)
          end

          appealRepliesQuery:start()
      end
    end

    function appealsQuery:onError(err)
      SFP.NET:SendUIError(pCaller, "BanAppeals", err)
    end

    appealsQuery:start()

  end

  function queryServer:onError(err)
    net.Start("SFP_UI_ERROR")
      net.WriteString("BanAppeals")
      net.WriteString(err)
    net.Send(pCaller)
  end

  queryServer:start()

end

local function structureDescriptor(tbl, separator)
 local struct = {}
 for k, v in pairs(tbl) do
  struct[k] = {
    id = k,
    name = v.Name or "Not Specified",
    version = v.Version or "Not specified"
  }
 end

 return struct
end

function SFP.NET:SendServerInfo(pPlayer)
  if (cockBlock(pPlayer)) then return end
  
  local databaseStatus = tostring( SFP.DB.STATUS == SFP.DBSTATUS.SUCCESS )
  local serverStatus
  local commandList = structureDescriptor(SFP._tConcommads, "\n")
  local moduleList = structureDescriptor(SFP._tModules, "\n")
  local serverConn = string.Explode(  ":", SFP.CONFIG("General"):Get("ServerIP") )
  local ip = serverConn[1]
  local port = serverConn[2]
  
  local query = [[
    SELECT id
    FROM `sfp_servers`
    WHERE ip = ':ip:'
    AND port = ':port:'
    AND game = 'garrysmod'
  ]]

  query = query:Replace(":ip:", ip)
  query = query:Replace(":port:", port)

  local queryServer = SFP.DB:Get():query(query)

  function queryServer:onSuccess(row)
    net.Start("SFP_RequestServerInfo")
      net.WriteTable({
        database = databaseStatus,
        commands = commandList,
        modules = moduleList,
        serverstatus = "Connected to panel | ID: " .. row[1].id
      })
    net.Send(pPlayer)
  end

  function queryServer:onError(err)
    net.Start("SFP_RequestServerInfo")
      net.WriteTable({
        database = databaseStatus,
        serverid = row[1].id,
        commands = commandList,
        modules = moduleList,
        serverstatus = "false"
      })
    net.Send(pPlayer)
    SFP.NET:SendUIError( pPlayer, "Info.panelConnection", "Server not registered in SFPortal." )
  end

  queryServer:start()
end

net.Receive("SFP_RequestChatLog", function(xLen, pPlayer)
  if (cockBlock(pPlayer)) then return end

  local query = [[
    SELECT * FROM (
      SELECT *
      FROM sfp_chat
      ORDER BY id DESC LIMIT 50
    ) sub
    ORDER BY id ASC
  ]]
  local chatLogQuery = SFP.DB:Get():query(query)
    
  function chatLogQuery:onSuccess(data)
    local chatLog = {}

    for _ = 1, #data do
      chatLog[_] = {
        ID = data[_].id,
        SteamID = data[_].steamid,
        Name = data[_].name,
        Message = data[_].message,
        Date = data[_].date
      }
    end

    local jsonDATA = util.TableToJSON(chatLog)
    local compressedDATA = util.Compress(jsonDATA)

    net.Start("SFP_RequestChatLog")
      net.WriteUInt(#compressedDATA, 32)
      net.WriteData(compressedDATA, #compressedDATA)
    net.Send(pPlayer)
  end

  function chatLogQuery:onError(err)
    Aw:LogError("Error on the query :), %s", err)
  end

  chatLogQuery:start()
end)

function SFP.NET:SendChatLog(pCaller)
  if (cockBlock(pCaller)) then return end

  if !pCaller then return end
  if !IsValid(pCaller) then return end

  local query = [[
    SELECT * FROM sfp_chat ORDER BY ID DESC LIMIT 50 ;
  ]]
  
  local response = SFP.DB:Get():query(query)

  function response:onSuccess(data)
    net.Start("SFP_RequestChatLog")
      for i,v in ipairs(data) do
          net.WriteString(data[i].steamid)
          net.WriteString(data[i].message)
          net.WriteString(data[i].date)
      end
    net.Send(pCaller)
  end  

  function response:onError(err)
    SFP.NET:SendUIError( pPlayer, "ChatLog", err)
  end

  response:start()
end

net.Receive("SFP_RequestServerInfo", function(xLen, pPlayer)
  SFP.NET:SendServerInfo(pPlayer)
end)


function SFP.NET:OpenMenu(pPlayer)
  net.Start("SFP_OpenMenu")
  net.Send(pPlayer)
end

hook.Add("PlayerSay", "SFP_HookChatCommand", function(pPlayer, sText)
  if (sText == "!sfpmenu") then
    if (cockBlock(pPlayer)) then 
      return "You are not allowed to use that command."
    end
    -- If it stops here, you got cockblocked.
    SFP.NET:OpenMenu(pPlayer)
  end
end)

net.Receive("SFP_DenyAppeal", function(xLen, pCaller)
  SFP.NET:DenyAppeal(pCaller, net.ReadString())
end)
function SFP.NET:DenyAppeal(pCaller, appealID)
  if (cockBlock(pCaller)) then 
    return 
  end
  -- Send $> Message.
  -- Send appeal Deny.
  local appealID = appealID
  local query = [[
    UPDATE `sfp_appeals` SET 
    status = 'reject'
    WHERE id = ':appealID:'
  ]]
  query = query:Replace(":appealID:", appealID)

  local queryAppeal = SFP.DB:Get():query(query)

  function queryAppeal:onSuccess(data)
    -- SFP.NET:SendUIMessage(pCaller, "Appeal.denied#" .. appealID)

    local query = [[
      INSERT INTO `sfp_appealreplies` (`replyname`, `appealid`, `reply`, `replyid`, `replydate`)
      VALUES( ':playername:', ':appealid:', ':reply:', ':steamid:', ':replydate:' );
    ]]

    query = query:Replace(":appealid:", appealID)
    query = query:Replace(":reply:", "$>"..Aw.L:Translate("SFPortal", "events.denied_appeal") )
    query = query:Replace(":replydate:", os.time())
    query = query:Replace(":steamid:", pCaller:SteamID64())
    query = query:Replace(":playername:", pCaller:Nick())

    local queryReply = SFP.DB:Get():query(query)

    function queryReply:onSuccess(data)
      net.Start("SFP_DenyAppeal")
        net.WriteString(appealID)
      net.Send(pCaller)
    end

    function queryReply:onError(err)
      Aw:LogTrace("Query error: %s", err)
      SFP.NET:SendUIError(pCaller, "Appeal.reply#"..appealID, err)
    end

    queryReply:start()

  end

  function queryAppeal:onError(err)
    SFP.NET:SendUIError( pPlayer, "Appeal.reply#"..appealID, err)
  end

  queryAppeal:start()
end

net.Receive("SFP_AcceptAppeal", function(xLen, pCaller)
  SFP.NET:AcceptAppeal(pCaller, net.ReadString(), net.ReadString())
end)

function SFP.NET:AcceptAppeal(pCaller, appealID, banID)
  if (cockBlock(pCaller)) then 
    return 
  end
  -- Send $> Message.
  -- Send appeal Accept.
  local appealID = appealID
  local query = [[
    UPDATE sfp_appeals t1, sfp_bans t2 SET 
    t2.Length = 0,
    t2.MTime = NOW(),
    t1.status = 'approve'

    WHERE t1.id = ':appealID:' and t2.BanID = ':banID:';
  ]]
  query = query:Replace(":appealID:", appealID)
  query = query:Replace(":banID:", banID)

  local queryAppeal = SFP.DB:Get():query(query)
  function queryAppeal:onSuccess(data)
    -- SFP.NET:SendUIMessage(pCaller, "Appeal.denied#" .. appealID)

    local query = [[
      INSERT INTO `sfp_appealreplies` (`replyname`, `appealid`, `reply`, `replyid`, `replydate`)
      VALUES( ':playername:', ':appealid:', ':reply:', ':steamid:', ':replydate:' );
    ]]

    query = query:Replace(":appealid:", appealID)
    query = query:Replace(":reply:", "$>"..Aw.L:Translate("SFPortal", "events.accepted_appeal") )
    query = query:Replace(":replydate:", os.time())
    query = query:Replace(":steamid:", pCaller:SteamID64())
    query = query:Replace(":playername:", pCaller:Nick())

    local queryReply = SFP.DB:Get():query(query)

    function queryReply:onSuccess(data)
      net.Start("SFP_AcceptAppeal")
        net.WriteString(appealID)
      net.Send(pCaller)
    end

    function queryReply:onError(err)
      Aw:LogTrace("Query error: %s", err)
      SFP.NET:SendUIError(pCaller, "Appeal.reply#"..appealID, err)
    end

    queryReply:start()

  end

  function queryAppeal:onError(err)
    SFP.NET:SendUIError( pPlayer, "Appeal.reply#"..appealID, err)
  end

  queryAppeal:start()
end

net.Receive("SFP_SendAppealMessage", function(xLen, pCaller)
  SFP.NET:SendAppealMessage(pCaller, net.ReadString(), net.ReadString())
end)

function SFP.NET:SendAppealMessage(pCaller, sMessage, tTicketID)
  if (cockBlock(pCaller)) then 
    return 
  end
  
  local appealID = appealID
  local query = [[
    UPDATE `sfp_appeals` SET 
    status = 'in_progress'
    WHERE id = ':appealID:'
  ]]
  query = query:Replace(":appealID:", tTicketID)

  local queryAppeal = SFP.DB:Get():query(query)

  function queryAppeal:onSuccess(data)

    local query = [[
      INSERT INTO `sfp_appealreplies` (`replyname`, `appealid`, `reply`, `replyid`, `replydate`)
      VALUES( ':playername:', ':appealid:', ':reply:', ':steamid:', ':replydate:' );
    ]]

    query = query:Replace(":appealid:", tTicketID)
    query = query:Replace(":reply:", sMessage)
    query = query:Replace(":replydate:", os.time())
    query = query:Replace(":steamid:", pCaller:SteamID64())
    query = query:Replace(":playername:", pCaller:Nick())

    local queryReply = SFP.DB:Get():query(query)

    function queryReply:onSuccess(data)
    end

    function queryReply:onError(err)
      SFP.NET:SendUIError(pCaller, "Appeal.reply#"..tTicketID, err)
    end

    queryReply:start()
  end

  function queryAppeal:onError(err)
    SFP.NET:SendUIError( pPlayer, "Appeal.reply#"..tTicketID, err)
  end

  queryAppeal:start()
end

net.Receive("SFP_SendMessage", function(xLen, pPlayer)
  if (cockBlock(pPlayer)) then return end

  local query = [[
    INSERT INTO `sfp_chat` (`steamid`, `name`, `message`, `date`) 
    VALUES (':steamid:', ':playernick:', ':message:', ':time:')]]

  
  local steamid = pPlayer:SteamID64()
  local playernick = pPlayer:Nick()
  local message = net.ReadString()
  local time = os.time()
  
  query = query:Replace(":steamid:", SFP.DB:Get():escape(steamid) )
  query = query:Replace(":playernick:", SFP.DB:Get():escape(playernick) )
  query = query:Replace(":message:", SFP.DB:Get():escape(message) )
  query = query:Replace(":time:", SFP.DB:Get():escape(time) )
    

  Aw:LogTrace("Message: %s, Query: %s", message, query)
  local sendMessageQuery = SFP.DB:Get():query(query)

  function sendMessageQuery:onSuccess(data)
    -- SFP.NET:SendChatMessage(pPlayer)
    Aw:LogTrace("Player %s - Send message %s to sfportal chat", playernick, message)
  end

  function sendMessageQuery:onError(err)
    Aw:LogTrace("Error sending message: %s", err)
    SFP.NET:SendUIError( pPlayer, "ChatLog", err)
  end

  sendMessageQuery:start()
  
end)