
Aw.UI:CreateFont("AdminUI.AppealRibbon.ActorName", 22, "Montserrat SemiBold")
Aw.UI:CreateFont("AdminUI.AppealRibbon.status", 14, "Montserrat SemiBold")
Aw.UI:CreateFont("AdminUI.AppealRibbon.Reason", 18, "Montserrat Regular")
Aw.UI:CreateFont("AdminUI.AppealRibbon.Info", 12, "Montserrat Regular")

local pnl = {}

AccessorFunc(pnl, "m_count", "Count")

function pnl:Init()
    self.Alpha = 0
    self.Ticket = {}
    self.Reason = "Ticket Reason"
    self.Time   = os.date("%X")
    self.Actor = "Offline Player"

    self.AvatarWrapper = self:Add("EditablePanel")

    self.ActorAvatar = self.AvatarWrapper:Add("Aw.UI.Panel.Avatar")
    self.ActorAvatar:SetVertices(33)
    
    self.CallerInfo = self:Add("EditablePanel")
    self.CallerInfo.Paint = function(s,w,h)
        surface.SetFont("AdminUI.AppealRibbon.ActorName")
        local nw, nh = surface.GetTextSize(self.Actor .. (self:GetCount() > 1 and "and +" .. self:GetCount() - 1 or "") )
        surface.SetFont("AdminUI.AppealRibbon.Info")
        local iw, ih = surface.GetTextSize(self.Time)

        draw.SimpleText(self.Actor .. (self:GetCount() > 1 and " + " .. self:GetCount() - 1 or ""), "AdminUI.AppealRibbon.ActorName", 16, h/2 - ih/2, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
        draw.SimpleText(self.Time, "AdminUI.AppealRibbon.Info",16, h/2 + nh/2, ColorAlpha(color_white,150), TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
    end

    self.WarnLabel = self:Add("EditablePanel")
    self.WarnLabel.Paint = function(s,w,h)
        draw.RoundedBox(0, 0, h/4, 2, h/2, ColorAlpha(color_white,10))
        draw.SimpleText(self.Reason, "AdminUI.AppealRibbon.Reason",16, h/2, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
    end

    self.StatusInfo = self:Add("EditablePanel")
    self.StatusInfo.Paint = function(s,w,h)
        draw.RoundedBox(0, 0, h/4, 2, h/2, ColorAlpha(color_white,10))

        -- local status, color
        -- if self.Ticket.Status == 1 then
        --     status, color = Aw.L:Translate("SFPortal", "states.solved"), Aw.UI.Theme.primary
        -- elseif self.Ticket.ASteamID and self.Ticket.Status == 2 then
        --     status, color = Aw.L:Translate("SFPortal", "states.ongoing"), Color(0, 189, 148)
        -- else
        --     status, color = Aw.L:Translate("SFPortal", "states.pending"), Color(255, 83, 83)
        -- end

        draw.RoundedBox(4, w/2 - 52, h/2 - 15, 104, 30, self.Ticket.Status == "in_progress" and Color(0, 189, 148) or Color(255, 83, 83))
        draw.SimpleText(
            self.Ticket.Status == "in_progress" and Aw.L:Translate("SFPortal", "states.ongoing") or Aw.L:Translate("SFPortal", "states.pending"), 
            "AdminUI.AppealRibbon.status",
            w/2, 
            h/2, 
            color_white, 
            TEXT_ALIGN_CENTER, 
            TEXT_ALIGN_CENTER
        )
    end

end

function pnl:PerformLayout(w,h)
    self:SetCursor("hand")

    self:DockMargin(8,0,8,8)
    self:DockPadding(4, 4, 4, 4)

    self.AvatarWrapper:Dock(LEFT)
    self.AvatarWrapper:SetWide(self.AvatarWrapper:GetTall())

    self.ActorAvatar:Dock(FILL)

    self.CallerInfo:Dock(LEFT)
    self.CallerInfo:SetWide(w * .16)

    self.WarnLabel:Dock(LEFT)
    self.WarnLabel:SetWide(w * .64)

    self.StatusInfo:Dock(FILL)

    for _, element in pairs(self:GetChildren()) do
        element:SetMouseInputEnabled(false)
    end
end

function pnl:Paint(w,h)
    local x, y = self:LocalToScreen()
    Aw.UI:DrawRoundedBox(8, 0, 0, w, h, Aw.UI.Theme.navbar)

    Aw.UI:Mask(function()
        Aw.UI:DrawRoundedBox(8, 0, 0, w, h, Aw.UI.Theme.navbar)
    end, function()
        draw.SimpleLinearGradient(x, y, w, h, ColorAlpha(Aw.UI.Theme.accent, self.Alpha), ColorAlpha(Aw.UI.Theme.navbar, 0), true)
    end)
end

function pnl:SetActor(sID64)
    self.ActorAvatar:SetSteamID(sID64)
    self.Actor = steamworks.GetPlayerName(sID64)
end

function pnl:SetInfo(sTime, sReason)
    self.Reason = sReason or ""
    self.Time = os.date( "%X",sTime)
end

function pnl:SetTicket(tTicket)
    self.Ticket = tTicket
end

function pnl:SetStaff(pPlayer)
end

function pnl:OnCursorEntered()
    self:Lerp("Alpha", 255, .3)

    if not self.Ticket.ASteamID then return end

    -- self.Tooltip = vgui.Create("Aw.UI.Panel.Tooltip")
    -- self.Tooltip:SetText("Claimed by " .. steamworks.GetPlayerName(self.Ticket.ASteamID) )
    -- self.Tooltip:SetVisible( false )

    -- timer.Simple( .5, function()

    --     if ( !IsValid( self.Tooltip ) ) then return end
    --     if ( !IsValid( self ) ) then return end

    --     self.Tooltip:SetVisible( true )

    -- end )


end

function pnl:OnCursorExited()
    self:Lerp("Alpha", 0, .3)
    if IsValid(self.Tooltip) then
        self.Tooltip:Remove()
    end
end

function pnl:OnMousePressed(keyCode)
    if keyCode == MOUSE_LEFT then
      local window = vgui.Create("AdminUI.Menu.AppealWindow")
      window:SetSize( ScrW() * .45, ScrH() * .9 )
      window:Center()
      window:MakePopup()
      window:SetTicket(self.Ticket)
    elseif keyCode == MOUSE_RIGHT then
      Aw:OpenContextMenu("Appeal", {}) -- TODO: Send appeal as argument for math op.
    else
        return false
    end
end

vgui.Register("AdminUI.AppealRibbon", pnl)