
Aw.UI:CreateFont("AdminUI.WarnRibbon.ActorName", 26, "Montserrat SemiBold")
Aw.UI:CreateFont("AdminUI.WarnRibbon.status", 16, "Montserrat SemiBold")
Aw.UI:CreateFont("AdminUI.WarnRibbon.Info", 18, "Montserrat Regular")

local pnl = {}

function pnl:Init()
    self.Count = 0
    self.Status = false
    self.Warnings = "--"
    self.Actor = "Offline player"


    self.avatarWrapper = self:Add("EditablePanel")

    self.actorAvatar = self.avatarWrapper:Add("Aw.UI.Panel.Avatar")
    self.actorAvatar:SetVertices(33)


    self.callerInfo = self:Add("EditablePanel")
    self.callerInfo.Paint = function(s,w,h)

        surface.SetFont("AdminUI.WarnRibbon.ActorName")
        local nw, nh = surface.GetTextSize(self.Actor .. (self.Count > 0 and "and +" .. self.Count or "") )

        surface.SetFont("AdminUI.WarnRibbon.Info")
        local iw, ih = surface.GetTextSize(self.Warnings)

        draw.SimpleText(self.Actor, "AdminUI.WarnRibbon.ActorName", 16, h/2 - ih/2, Color(255, 255, 255), TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
        
        draw.SimpleText(self.Warnings, "AdminUI.WarnRibbon.Info",16, h/2 + nh/2, ColorAlpha(Color(255, 255, 255),150), TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
    end

end

function pnl:PerformLayout(w,h)
    self:SetCursor("hand")

    self:DockMargin(16,0,16,16)
    self:DockPadding(4, 4, 4, 4)

    self.avatarWrapper:Dock(LEFT)
    self.avatarWrapper:SetWide(self.avatarWrapper:GetTall())

    self.actorAvatar:Dock(FILL)

    self.callerInfo:Dock(FILL)


    for _, element in pairs(self:GetChildren()) do
        element:SetMouseInputEnabled(false)
    end
end

function pnl:Paint(w,h)
    local x, y = self:LocalToScreen()
    -- print("ActorID:", self.ActorId, "Admin:", self.Ticket.AdminId, "Color?", self.Ticket.AdminId == self.ActorId)
    Aw.UI:DrawRoundedBox(8, 0, 0, w, h, self.Ticket.AdminId == self.ActorId and Aw.UI.Theme.staff or Aw.UI.Theme.navbar)
end

function pnl:SetActor(sID64)
    self.actorAvatar:SetSteamID(sID64)
    self.Actor = steamworks.GetPlayerName(sID64)
    self.ActorId = sID64 or "123456789000000"
end

function pnl:SetInfo(sReason, bStatus)
    self.Status = bStatus or false
    self.Reason = sReason or ""
end

function pnl:SetTicket(tTicket)
    self.Ticket = tTicket
end

function pnl:OnCursorEntered()
    self:SetCursor("none")
end

vgui.Register("AdminUI.AppealRibbon.Player", pnl)