Aw.UI:CreateFont("AdminUI.ContextMenu.Option", 18, "Montserrat Regular")

Aw.Actions = {
  Appeal = {
    ["actions.reply"] = {
      ShouldShow = function() return false end,
      Action = function(tAppeal)
        return 0
      end
    },
    ["actions.deny"] = {
      ShouldShow = function() return false end,
      Action = function(tAppeal)
        return 0
      end
    },
    ["actions.accept"] = {
      ShouldShow = function() return false end,
      Action = function(tAppeal)
        return 0
      end
    },
    ["actions.soon"] = {
        ShouldShow = function() return true end,
        action = function(tAppeal)
            return 0
        end
    }
  }
}

local pnl = {}

function pnl:Init()
    self.Wide = 100
    self.OptionTall = 32
    self.Object = {}
    self.Options = {}

    self:SetZPos(99)
end

function pnl:PerformLayout(w,h)
    local mx, my = gui.MousePos()
    local sw, sh = ScrW(), ScrH()
    local px, py = 0, 0

    self:SetPos( ( (mx + w) < sw) and (mx) or (sw - w), (my + h < sh) and (my) or (sh - h))
end

function pnl:Paint(w,h)
    draw.RoundedBox(6, 0, 0, w, h, Aw.UI.Theme.primary)
end

function pnl:AddOption(sOption, fCallback, tObject)
    Aw.UI:CreateFont("Aw.UI.Font.ContextMenu", 18, "Montserrat Regular")

    local optionButton = self:Add("DButton")
    optionButton.Color = Aw.UI.Theme.primary
    optionButton:Dock(TOP)
    optionButton:SetFont("Aw.UI.Font.ContextMenu")

    optionButton:SetText( sOption )
    optionButton:SetContentAlignment(4)
    optionButton:SetTextInset(8, 0)
    optionButton:SetTextColor(color_white)
    optionButton.Paint = function(s,w,h)
        draw.RoundedBox(0, 0, 0, w, h, s.Color)
    end
    optionButton.OnCursorEntered = function(s)
        s:LerpColor("Color", Aw.UI.Theme.accent)
    end
    optionButton.OnCursorExited = function(s)
        s:LerpColor("Color", Aw.UI.Theme.primary)
    end

    optionButton.DoClick = function(s)
        fCallback(self.Object)
        self:Remove()
    end

    self.Options[#self.Options + 1] = optionButton

    surface.SetFont("AdminUI.ContextMenu.Option")
    local tw = surface.GetTextSize(sOption )
    -- local tw = #sOption

    if tw + 16 > self.Wide then self.Wide = tw + 16 end

    self:InvalidateLayout(false)

    optionButton:SetTall(self.OptionTall)
    self:SetTall( self.OptionTall * #self.Options + 16 )
    self:DockPadding(0, 8, 0, 8)
    self:SetWide( self.Wide )

    self:AddHook( "GUIMouseReleased", "Aw.UI.ContextMenu.ClickCheck", function(sKeyCode)
        if not self:InBound() then
            self:Remove()
        end
    end)
end

function pnl:InBound()
    local w, h = self:GetWide(), self:GetTall()
    local px, py = self:LocalToScreen()
    local mx, my = gui.MousePos()
    local tx, ty = math.Clamp(mx - px, -1, w + 1), math.Clamp(my - py, -1, h + 1)
    return  (tx < w and tx >= 0) and (ty < h + 1 and ty >= 0)
end

function pnl:SetObject(sEntry, tObject)
    if !Aw.Actions[sEntry] then self:Remove() return end

    self.Object = tObject
    for name, action in pairs(Aw.Actions[sEntry]) do
        local callback = nil
        
        if istable(action) then
            if action.ShouldShow(tObject) then
                callback = action.Action
            else
                continue
            end
        else
            callback = action
        end

        if callback then
            self:AddOption(Aw.L:Translate("SFPortal", name), callback, tObject)
        end
    end
end

function pnl:CheckFocus()
    if not self:HasFocus() then self:Remove() end
end

function pnl:OnFocusChanged(bOnFocus)
    Aw:Debounce("AwAdmin.ContextMenu.FocusCheck", .2, function()
        if !IsValid(self) then return end
        self:CheckFocus()
    end)
end

vgui.Register("AdminUI.Panel.ContextMenu", pnl, "EditablePanel")


function Aw:OpenContextMenu(sEntry, tObject)
    if IsValid(Aw.ContextMenu) then Aw.ContextMenu:Remove() end
    Aw.ContextMenu = vgui.Create("AdminUI.Panel.ContextMenu")
    Aw.ContextMenu:SetObject(sEntry, tObject)
    Aw.ContextMenu:MakePopup()

    -- timer.Simple(3, function()
    --     if IsValid(Aw.ContextMenu) then
    --         AdminUI.ContextMenu:Remove()
    --     end
    -- end)

end
