
local pnl = {}

function pnl:Init()

    Aw.UI:CreateFont("AdminUI.TicketWindow.Identificator", 22, "Montserrat SemiBold")

    self.Title = "Appeal #666"
    self.Players = {}
    self.Ticket = {}

    self.header = self:Add("DPanel")
    self.header.Paint = function(s,w,h)
        draw.RoundedBoxEx(6, 0, 0, w, h, Aw.UI.Theme.navbar,true,true)
    end

    self.status = self.header:Add("DPanel")
    self.status.Paint = function(s,w,h)
        -- Aw:LogTrace(self.Ticket.Status)
        draw.RoundedBox(4, w/2 - 52, h/2 - 15, 104, 30, self.Ticket.Status == "in_progress" and Color(0, 189, 148) or Color(255, 83, 83))
        draw.SimpleText(self.Ticket.Status == "in_progress" and Aw.L:Translate("SFPortal", "states.ongoing") or Aw.L:Translate("SFPortal", "states.pending"), "AdminUI.WarnRibbon.status",w/2, h/2, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
    end

    self.identificator = self.header:Add("DLabel")
    self.identificator:SetText(self.Title)
    self.identificator:SetTextColor(color_white)
    self.identificator:SetFont("AdminUI.TicketWindow.Identificator")

    self.close = self.header:Add("DButton")
    self.close:SetText("X")
    self.close:SetTextColor(color_white)
    self.close:SetFont("AdminUI.TicketWindow.Identificator")
    self.close.Paint = function(s,w,h)
    end
    self.close.DoClick = function(s,w,h)
        self:Remove()
    end

    self.Scroll = self:Add("Aw.UI.Panel.Scroll")

    self:AddHook("AWESOME.ADMIN.PanelUpdateTicket", "Panel.UpdateTicketWindow", function(s, ticket)
        if self.Ticket.Id != ticket.Id then return end
        self.Ticket = ticket
    end)

    self.header:Dock(TOP)
    self.status:Dock(LEFT)
    self.close:Dock(RIGHT)
    self.Scroll:Dock(FILL)
end

function pnl:PerformLayout(w,h)
    self.header:SetTall(40)

    self.identificator:Dock(FILL)

    self.close:SetWide(self.header:GetTall())

    self.status:SetWide(120)

end

function pnl:SetTicket(tBanDATA)
    self.Title = "BanID #" .. tBanDATA.BanID or "BanID #663"
    self.Ticket = tBanDATA
    self.identificator:SetText(self.Title)

    self:BuildPlayers(tBanDATA)
    self:BuildChat(tBanDATA)
    self:BuildActions()
end

function pnl:BuildPlayers(tTicket)
    if IsValid(self.PlayerList) then self.PlayerList:Remove() end

    self.PlayerList = self.Scroll:Add("AdminUI.TextRibbon")
    self.PlayerList:SetText(Aw.L:Translate("SFPortal", "text.involved"))
    self.PlayerList:Dock(TOP)

    for _, player in ipairs(tTicket.Comments) do
        if self.Players[player.ID] then self.Players[player.ID]:Remove() end
        self.Players[player.ID] = self.Scroll:Add("AdminUI.AppealRibbon.Player")
        local steamID = tostring( player.ID )

        if steamID:lower():sub(1, 5) == "steam" then
            steamID = util.SteamIDTo64( steamID )
        end

        self.Players[player.ID]:SetActor(steamID)
        self.Players[player.ID]:SetTicket(tTicket)
        // TODO: Count ban record and print it out
        -- print(player.ID , tTicket.AdminId, player.ID == tTicket.AdminId and Aw.L:Translate("SFPortal", "text.staff") or Aw.L:Translate("SFPortal", "text.nobanrecord")) 
        self.Players[player.ID].Warnings = steamID == tTicket.ASteamID and Aw.L:Translate("SFPortal", "text.staff") or Aw.L:Translate("SFPortal", "text.nobanrecord")
        self.Players[player.ID]:Dock(TOP)
        self.Players[player.ID]:SetTall(64)
    end
end

function pnl:BuildChat(tTicket)
    self.bubble = {}
    self.action = {}

    if IsValid(self.Message) then self.Message:Remove() end
    self.Message = self.Scroll:Add("AdminUI.TextRibbon")
    self.Message:SetText(Aw.L:Translate("SFPortal", "text.message"))
    self.Message:Dock(TOP)
    local last_id = 0

    for _, comment in pairs(tTicket.Comments) do
        if IsValid(self.bubble[_]) then self.bubble[_]:Remove() end
        PrintTable(comment)
        local sMessage = comment.Reply

        local s, e, p = string.find(sMessage, "$>", 1, true)
        if s then
            sMessage = string.sub( sMessage, e+1, -1)
            sMessage = sMessage:Trim(" ")
                local id = #self.action +1
                if IsValid(self.action[id]) then self.action[id]:Remove() end
                self.action[id] = self.Scroll:Add("AdminUI.ChatBubble.Action")
                -- self.action[id]:SetText(AwAdmin:L(sMessage, steamworks.GetPlayerName(comment.UserId)))
                steamworks.RequestPlayerInfo( comment.ID, function( steamName )
                    self.action[id]:SetText( Aw.L:Translate( "SFPortal", sMessage, steamName or "JOo") )
                end )
                continue
        end
        self.bubble[_] = self.Scroll:Add("AdminUI.ChatBubble")
        local steamID = tostring( comment.ID )

        if steamID:lower():sub(1, 5) == "steam" then
            steamID = util.SteamIDTo64( steamID )
        end

        self.bubble[_]:SetSpeaker(steamID)
        if tTicket.ASteamID ~= nil then
            self.bubble[_]:SetClaimer(tTicket.PSteamID)
        end
        self.bubble[_]:SetText(sMessage)
        self.bubble[_]:DockMargin(0, 8, 0, 8)
        self.bubble[_]:Dock(TOP)
        timer.Simple(.1, function()
            self.Scroll:ScrollToChild(self.bubble[_])
          end)
        last_id = _
    end

    
    self.sendBoxWrapper = self:Add("DPanel")
    self.sendBoxWrapper:Dock(BOTTOM)
    self.sendBoxWrapper:SetTall(42)
    self.sendBoxWrapper:DockMargin(8, 8, 8, 8)
    self.sendBoxWrapper:SetZPos(3)
    self.sendBoxWrapper.Paint = nil
  
    self.input = self.sendBoxWrapper:Add("Aw.UI.Panel.TextEntry")
    self.input:Dock(FILL)
    self.input:SetPlaceholder("Type here...")
    self.input:OnEnter(function()
      SFP.NET:RequestSendAppealMessage(self.input:GetText(), self.Ticket.ID)
      self.bubble["Optmistic" .. self.input:GetText()] = self.Scroll:Add("AdminUI.ChatBubble")
      self.bubble["Optmistic" .. self.input:GetText()]:SetSpeaker(LocalPlayer():SteamID64())
      self.bubble["Optmistic" .. self.input:GetText()]:SetText(self.input:GetText())
      self.bubble["Optmistic" .. self.input:GetText()]:Dock(TOP)
      self.bubble["Optmistic" .. self.input:GetText()]:SetTall(64)
    --   self.bubble["Optmistic" .. self.input:GetText()]:DockMargin(8, 8, 8, 8)
      local name = self.input:GetText()
      timer.Simple(.1, function()
        self.Scroll:ScrollToChild(self.bubble["Optmistic" .. name])
      end)
      self.input:SetText("")
    end)
  
    
    self.send = self.sendBoxWrapper:Add("Aw.UI.Panel.Button")
    self.send:SetWide(64)
    self.send:Dock(RIGHT)
    self.send:SetText("Send")
    self.send:SetBody(self.sendBoxWrapper)
    self.send:SetDisabled(false)
    self.send:SetBordered(false)
    self.send:SetBackgroundColor(Aw.UI.Theme.navbar)
    self.send:SetMargin(16)
    self.send:SetRadius(8)
    self.send:Deploy()
    self.send:DockMargin(8, 0, 8, 0)
    self.send.DoClick = function()
      SFP.NET:RequestSendAppealMessage(self.input:GetText(), self.Ticket.ID)
      self.bubble["Optmistic" .. self.input:GetText()] = self.Scroll:Add("AdminUI.ChatBubble")
      self.bubble["Optmistic" .. self.input:GetText()]:SetSpeaker(LocalPlayer():SteamID64())
      self.bubble["Optmistic" .. self.input:GetText()]:SetText(self.input:GetText())
      self.bubble["Optmistic" .. self.input:GetText()]:Dock(TOP)
      self.bubble["Optmistic" .. self.input:GetText()]:SetTall(64)
    --   self.bubble["Optmistic" .. self.input:GetText()]:DockMargin(8, 8, 8, 8)
      local name = self.input:GetText()
      timer.Simple(.1, function()
        self.Scroll:ScrollToChild(self.bubble["Optmistic" .. name])
      end)
      self.input:SetText("")
    end

end

function pnl:BuildActions()
    if IsValid(self.ActionsContainer) then self.ActionsContainer:Remove() end
    if IsValid(self.Actions) then self.Actions:Remove() end
    if self.Ticket.Status == 3 then return end

    self.ActionsContainer = self:Add("DPanel")
    self.ActionsContainer:DockMargin(16, 0, 16, 16)
    self.ActionsContainer.Paint = nil

    self.Actions = self:Add("AdminUI.TextRibbon")
    self.Actions:SetText(Aw.L:Translate("SFPortal", "text.actions"))

    --
    self.Actions:Dock(BOTTOM)
    self.Actions:SetZPos(2)

    self.ActionsContainer:Dock(BOTTOM)
    self.ActionsContainer:SetTall(48)
    self.ActionsContainer:SetZPos(1)

    
    self.acceptButton = self.ActionsContainer:Add("Aw.UI.Panel.Button")
    self.acceptButton:SetDisabled(self.Ticket.ASteamID and true or false)
    self.acceptButton:SetText("Accept")
    self.acceptButton:SetBordered(true)
    self.acceptButton:SetBorderThickness(2)
    self.acceptButton:SetBackgroundColor(Color(100,100,100,255))
    self.acceptButton:SetMargin(16)
    self.acceptButton:SetRadius(8)
    self.acceptButton:Deploy()
    self.acceptButton.DoClick = function()
        SFP.NET:AcceptAppeal( self.Ticket.ID, self.Ticket.BanID )
        self.bubble["Optmistic_accept"] = self.Scroll:Add("AdminUI.ChatBubble.Action")
        self.bubble["Optmistic_accept"]:SetText( Aw.L:Translate( "SFPortal", "events.accept_appeal", steamName or "JOo") )
        timer.Simple(.1, function()
            self.Scroll:ScrollToChild(self.bubble["Optmistic_accept"])
        end)
        self.input:SetText("")
    end

    self.denyButton = self.ActionsContainer:Add("Aw.UI.Panel.Button")
    self.denyButton:SetText("Deny")
    self.denyButton:SetBody(self.ActionsContainer)
    self.denyButton:SetDisabled(self.Ticket.ASteamID and (self.Ticket.ASteamID == LocalPlayer():SteamID64() and false or true) or  false)
    self.denyButton:SetBordered(true)
    self.denyButton:SetBorderThickness(2)
    self.denyButton:SetBackgroundColor(Color(100,100,100,255))
    self.denyButton:SetMargin(16)
    self.denyButton:SetRadius(8)
    self.denyButton:Deploy()
    self.denyButton.DoClick = function()
        SFP.NET:DenyAppeal( self.Ticket.ID )
        self.bubble["Optmistic_deny"] = self.Scroll:Add("AdminUI.ChatBubble.Action")
        self.bubble["Optmistic_deny"]:SetText( Aw.L:Translate( "SFPortal", "events.denied_appeal", steamName or "JOo") )
        timer.Simple(.1, function()
            self.Scroll:ScrollToChild(self.bubble["Optmistic_deny"])
        end)
        self.input:SetText("")
    end

    Aw.UI:BuildButtonSizes(self.ActionsContainer)

end


function pnl:Paint(w,h)
    Derma_DrawBackgroundBlur(self)
    draw.RoundedBoxEx(6, 0, 0, w, h, Aw.UI.Theme.background,true,true)
end

function pnl:OnRemove()
end

vgui.Register("AdminUI.Menu.AppealWindow", pnl, "EditablePanel")
