local pnl = {}

function pnl:Init()
  self.header = self:Add("Aw.UI.Panel.FrameHeader")
  self.header:SetTitle("SFPortal - Menu")
  self.header:Dock(TOP)
  self.header:SetCanMinimize(true)

  self.sidebar = self:Add("Aw.UI.Panel.AnimatedSidebar")
  self.sidebar:SetBody(self)
  self.sidebar:CreateDivider()
  self.sidebar:CreatePanel(Aw.L:Translate("SFPortal", "pages.status"), "sfp:ui:pages:stats", "INOV9hU", {["position"] = 4 })
  self.sidebar:CreatePanel(Aw.L:Translate("SFPortal", "pages.chat"), "sfp:ui:pages:staffchat", "MOK2iCV")
  self.sidebar:CreatePanel(Aw.L:Translate("SFPortal", "pages.appeals"), "sfp:ui:pages:banappeal", "mtXSaWC")
  self.sidebar:Dock(LEFT)

  self.sidebar:SetActiveByName(Aw.L:Translate("SFPortal", "pages.appeals"))
end

function pnl:PerformLayout(w,h)
  self.header:SetTall( 40 )

  self.sidebar:SetWide(64)
end

function pnl:Paint(w,h)
  draw.RoundedBox(6, 0, 0, w, h, Aw.UI.Theme.background)
end

function pnl:OnRemove()
  SFP.Menu = nil
end

function pnl:SetTitle(sTitle)
  self.header:SetTitle(sTitle)
end

vgui.Register('sfp:ui:frame', pnl, "EditablePanel")
