local pnl = {}

function pnl:Init()
  self.Activated = false
  self.Loading = true
  self.Ribbons = {}

  self.canvas = self:Add("Aw.UI.Panel.ScrollAnimated")
  -- self.canvas:SetCanvas(self)
  self.canvas:Dock(FILL)
  self.canvas:SetPadding(2)
  self.canvas:DockMargin(0, 8, 0, 8)

  self.loader = self.canvas:Add("DPanel")
  self.loader:Dock(TOP)
  self.loader.Paint = function(s,w,h)
    if !self.Loading then return end
    Aw.UI:DrawLoadingCircle(w/2, h/2, w/8, Color(255,255,255,255))
  end

  self:AddHook("SFP_UI_MESSAGE", "banappeal:addToList", function(pnlSelf, sChannel, sEventName, tEventData)
    
    if (sChannel != "BanAppeals") then
      return
    end
        
    self.Loading = false
    if (sEventName ~= "Success") then return end

    self.loader:SetTall(0)


    for _, v in pairs( tEventData ) do 
      self.Ribbons[_] = self.canvas:Add("AdminUI.AppealRibbon")
      self.Ribbons[_]:Dock(TOP)
      self.Ribbons[_]:SetTall(64)
      self.Ribbons[_]:SetCount(1)
      self.Ribbons[_]:SetActor(v.PSteamID)
      self.Ribbons[_]:SetInfo(v.Time, v.Reason)
      self.Ribbons[_]:SetStaff(v.ASteamID)
      self.Ribbons[_]:SetTicket(v)
    end
  end)

  self:AddHook("SFP_UI_MESSAGE", "banappeal:removeFromList", function(pnlSelf, sChannel, sEventName, tEventData)
    if (sEventName ~= "updatebanappeals") then return end

    local banId = tEventData.banId
    
  end)

end

function pnl:PerformLayout(w, h)
  if (self.Loading) then
    self.loader:SetTall( self.canvas:GetTall() - 32 )
  end
end

function pnl:Paint(w,h)
end

function pnl:Activate()
  if (self.Activated) then return end
  SFP.NET:RequestAppealsList() 
  self.Activated = true
end


vgui.Register("sfp:ui:pages:banappeal", pnl, "EditablePanel")